<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * Classe che esegue la ricerca in base al tipo di ricerca. Viene estesa dai template
    * dei componenti più ricchi come il componente ecommerce o il componente annunci
    */

    class MotoreDiRicerca {
        private $db;
        private $tipo;
        private $impostazioni;
        private $pagina;
        private $chiaveRicerca;
        private $elementiPerPagina;
        private $queryRicerca;
        private $queryConteggio;
        private $risultatiRicerca;
        private $numeroRisultatiRicerca;
        private $datiColonnaLaterale;
        private $datiBlog;
        private $impostazioniAspetto;
        private $contenutoSopraTitoloPagina;
        private $gestoreTraduzioni;
        private $linguaCorrente;
        
        /*
         * Parametri:
         *  $tipo                => tipo di ricerca da effetuare, quelle basi sono: autore, tag, ricerca (in tal caso cerca gli articoli)
         *  $chiaveRicerca       => l'elemento da ricercare
         *                          se il tipo di ricerca che si sta facendo è per categoria $chiaveRicerca 
         *                          sarà un array, altrimenti sarà una stringa
         *  $datiColonnaLaterale => array delle informazioni da passare alla colonna laterale,
         *                          nel template base deve essere riempito con i dati del blog
         */
        function __construct($db,$tipo, $impostazioni, $chiaveRicerca,$elementiPerPagina,$datiColonnaLaterale,$gestoreTraduzioni,$linguaCorrente) {
            $this->db   = $db;
            $this->tipo = $tipo;
            $this->impostazioni        = $impostazioni;
            $this->chiaveRicerca       = $chiaveRicerca;
            $this->elementiPerPagina   = $elementiPerPagina;
            $this->datiColonnaLaterale = $datiColonnaLaterale;
            $this->numeroRisultatiRicerca = 0;
            $this->pagina                 = 1;
            $this->datiBlog               = $this->db->leggiSingolaRiga("geec_blog",1);
            $this->impostazioniAspetto    = $this->db->leggiSingolaRiga("geecB_impostazioni",1);
            $this->contenutoSopraTitoloPagina = "";
            $this->gestoreTraduzioni          = $gestoreTraduzioni;
            $this->linguaCorrente             = $linguaCorrente;
        }

        /*
         * Nel caso si tratta di una ricerca per categoria i dati devono essere
         */
        function eseguiRicerca($aspettoSito,$pagina = 1) {
            $configurazioneAspetto         =  $this->db->leggiSingolaRiga("geec_configurazioniAspetto",1);
            $this->pagina                  = $pagina;
            $this->generaQuery();
            $this->numeroRisultatiRicerca  = $this->db->eseguiQueryLettura($this->queryConteggio)->num_rows;
            $this->risultatiRicerca        = $this->db->eseguiQueryLettura($this->queryRicerca);
            $this->stampaContenuti($configurazioneAspetto);
            if($this->impostazioni["salvaRicercheUtenti"]=="si") {
                $this->salvaRicercaNelDatabase();
            }
        }
        
        function generaQuery() {
            if($this->tipo!="categoria") {
                $chiaveDaCercare = $this->db->escapeString(htmlspecialchars($this->chiaveRicerca));
            }

            if($this->tipo=="autore") {//la ricerca viene effettuata per autore (l'utente ha cliccato sul link dell'autore di un articolo)	
                $this->queryConteggio = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND autore='$chiaveDaCercare' AND stato LIKE 'pubblicato' ORDER BY id DESC ";
                $this->queryRicerca   = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND autore='$chiaveDaCercare' AND stato LIKE 'pubblicato' ORDER BY id DESC ";
            }
            else if($this->tipo=="categoria") { // la ricerca viene effettuata per categoria
                $dataOggi = date("Y-m-d H-i");
                // costruisco la stringa per l'ordinamento
                if($this->chiaveRicerca["ordinamento"]=="Data di pubblicazione, dal più nuovo") {
                    $ordinamento = "ORDER BY dataPubblicazione DESC";
                }
                else if($this->chiaveRicerca["ordinamento"]=="Data di pubblicazione, dal più vecchio") {
                    $ordinamento = "ORDER BY dataPubblicazione ASC";
                }
                else if($this->chiaveRicerca["ordinamento"]=="Per titolo, crescente") {
                    $ordinamento = "ORDER BY titolo ASC";
                }
                else if($this->chiaveRicerca["ordinamento"]=="Per titolo, decrescente") {
                    $ordinamento = "ORDER BY titolo DESC";
                }
                else {
                    $ordinamento = "";
                }
                $this->queryConteggio = "SELECT * FROM geecB_contenuti WHERE 
                                            ( categoria='{$this->chiaveRicerca["id"]}' 
                                              OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre = {$this->chiaveRicerca["id"]} AND tipo LIKE 'categoriaArticolo')
                                              OR id IN (SELECT idContenuto FROM geec_associazioneCategorieContenuti WHERE idCategoria = {$this->chiaveRicerca["id"]}) 
                                            ) 
                                            AND stato LIKE 'pubblicato' 
                                            AND dataPubblicazione<='$dataOggi' ";
                $this->queryRicerca   = "SELECT * FROM geecB_contenuti WHERE 
                                            ( categoria='{$this->chiaveRicerca["id"]}' 
                                              OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre = {$this->chiaveRicerca["id"]} AND tipo LIKE 'categoriaArticolo') 
                                              OR id IN (SELECT idContenuto FROM geec_associazioneCategorieContenuti WHERE idCategoria = {$this->chiaveRicerca["id"]}) 
                                            ) 
                                            AND stato LIKE 'pubblicato' 
                                            AND dataPubblicazione<='$dataOggi' $ordinamento";

                $queryCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE '{$this->chiaveRicerca["tipo"]}' AND categoriaMadre='{$this->chiaveRicerca["id"]}' ORDER BY posizione ASC";
                $risSottoCategoria = $this->db->eseguiQueryLettura($queryCategoria);
                if($risSottoCategoria->num_rows>0) {
                    $this->contenutoSopraTitoloPagina = "<div class=\"form-row sottocategorie mb-2\">";
                }
                while($sottoCategoria=$risSottoCategoria->fetch_assoc()) {
                    $link = GeneratoreUrl::creaUrlCategoria($sottoCategoria,$this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);
                    if($sottoCategoria["foto"]!="") {
                        $this->contenutoSopraTitoloPagina .= "<div class=\"col-4 col-sm-3 col-xl-2 text-center mb-3\">
                                <a class=\"d-block pb-2 border-bottom border-primary\" href=\"$link\"><div class=\"background-image aspect-ratio-1-1 mb-2\" style=\"background: url('{$sottoCategoria["foto"]}');\">&nbsp;</div>
                                  <strong>{$sottoCategoria["nome"]}</strong>
                                </a>
                            </div>";
                    }
                    else {
                        $this->contenutoSopraTitoloPagina .= "<a class=\"btn btn-outline-primary mb-2 ml-2\" href=\"$link\" > {$sottoCategoria["nome"]}</a>";
                    }
                }
                if($risSottoCategoria->num_rows>0) {
                    $this->contenutoSopraTitoloPagina .= "</div>";
                }
            }
            else if($this->tipo=="ricerca") { // la ricerca viene effettuata per una parola chiave inserita dall'utente nel campo cerca
                if($this->impostazioni["rimuoviUltimaLettera"]) {
                    $chiaveDaCercare = substr($chiaveDaCercare, 0,-1);
                }
                $elementiDaCercare = [];
                if($this->impostazioni["cercaContenutiPerTitolo"]=="si") {
                    array_push($elementiDaCercare,"titolo");
                }
                if($this->impostazioni["cercaContenutiPerMetaDescrizione"]=="si") {
                    array_push($elementiDaCercare,"descrizione");
                }
                if($this->impostazioni["cercaContenutiPerMetaDescrizione"]=="si") {
                    array_push($elementiDaCercare,"metaDescrizione");
                }
                if($this->impostazioni["cercaContenutiPerTesto"]=="si") {
                    array_push($elementiDaCercare,"testo");
                }
                
                $stringaElementiDaCercare = $this->creaStringaQuery($elementiDaCercare,$chiaveDaCercare);
                
                $this->queryConteggio = "SELECT * FROM geecB_contenuti WHERE (tipo LIKE 'articolo' OR tipo LIKE 'pagina' OR tipo LIKE 'galleria') AND stato LIKE 'pubblicato'
                                            AND ($stringaElementiDaCercare)
                                            ORDER BY id DESC ";
                $this->queryRicerca   = "SELECT * FROM geecB_contenuti WHERE (tipo LIKE 'articolo' OR tipo LIKE 'pagina' OR tipo LIKE 'galleria') AND stato LIKE 'pubblicato'
                                            AND ($stringaElementiDaCercare)
                                            ORDER BY id DESC ";
            }
            else if($this->tipo=="tag") { // la ricerca viene effettuata per tag
                $queryTag = "SELECT * FROM geec_tag WHERE nome LIKE '$chiaveDaCercare'";
                
                $risTag = $this->db->eseguiQueryLettura($queryTag);
                $tag = $risTag->fetch_assoc();

                $this->queryConteggio = "SELECT a.id, a.titolo, a.linguaContenuto, a.categoria, a.alias, a.testo, a.foto, a.autore, a.dataCreazione, a.dataPubblicazione FROM geecB_contenuti AS a JOIN geecB_associazioniTagArticoli AS at
                        ON a.id = at.idArticolo WHERE a.stato LIKE 'pubblicato' AND at.idTag={$tag["id"]}
                        ORDER BY a.id DESC ";
                $this->queryRicerca   = "SELECT a.id, a.titolo, a.linguaContenuto, a.categoria, a.alias, a.testo, a.foto, a.autore, a.dataCreazione, a.dataPubblicazione FROM geecB_contenuti AS a JOIN geecB_associazioniTagArticoli AS at
                                        ON a.id = at.idArticolo WHERE a.stato LIKE 'pubblicato' AND at.idTag={$tag["id"]}
                                        ORDER BY a.id DESC ";
            }
            else {}
            
            // aggiungo limitazione per pagina alla query ricerca
            if($this->pagina==1) {
                $this->queryRicerca .= " LIMIT $this->elementiPerPagina";
            }
            else {
                $elementoPartenza    = $this->elementiPerPagina * ($this->pagina - 1);
                $this->queryRicerca .= " LIMIT $elementoPartenza, $this->elementiPerPagina";
            }
        }
        
        function stampaContenuti($configurazioneAspetto) {
            echo"<section class=\"blog articoli-dal-blog siOverflow\">
                    <div class=\"container\">
			<div class=\"row\">";
                            if($configurazioneAspetto["attivaColonnaSinistra"]=="si") {
                                VisualizzatorePannelloLaterale::stampa($this->db, $this->impostazioniAspetto, $configurazioneAspetto,"sinistra",$this->impostazioniAspetto["linguaSito"]);
                            }
                            
                            echo"<div class=\"{$configurazioneAspetto['colonnaCentrale']}\">";
                                    echo $this->getContenutoSopraTitoloPagina();
                                    echo $this->getTitoloPagina();
                                    echo"<div class=\"row\">";
			    if($this->tipo=="categoria") {
                                $this->stampaContenutiCategoria();
                            }
                            else {
                                $this->stampaContenutiRicerca($this->impostazioniAspetto);
                            }
                            $this->stampaPaginazione();
                            echo"</div>
                            </div>";
                            
                            if($configurazioneAspetto["attivaColonnaDestra"]=="si") {
                                VisualizzatorePannelloLaterale::stampa($this->db, $this->impostazioniAspetto, $configurazioneAspetto,"destra",$this->impostazioniAspetto["linguaSito"]);
                            }
			echo"</div>";
                echo"</div>"
            . "</section>";
        }
        
        function stampaContenutiRicerca() {
            while($articolo = $this->risultatiRicerca->fetch_assoc()) {
                $numeroCommenti = $this->db->contaRigheTabella("geecB_commenti",array("idContenuto"=>$articolo["id"]));
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);

                $arrayCategorie = array();
                if($articolo["categoria"]!=0) {
                    $categoriaPrincipale = $this->db->leggiSingolaRiga("geec_categorie",$articolo["categoria"]);
                    $arrayCategorie[$categoriaPrincipale["nome"]] = GeneratoreUrl::creaUrlCategoria($categoriaPrincipale, $this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);
                }
                $queryArticoli="SELECT c.* FROM geec_associazioneCategorieContenuti AS ac JOIN geec_categorie AS c "
                                . "ON c.id=ac.idCategoria "
                                . "WHERE ac.idContenuto = {$articolo["id"]}";
                $risCategorie = $this->db->eseguiQueryLettura($queryArticoli);
                while($categoria = $risCategorie->fetch_assoc()) {
                    $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);
                }
                
                StampaContenuti::stampaRisultatiRicerca($this->gestoreTraduzioni,$articolo, $this->datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo,$arrayCategorie, $numeroCommenti);
            }
        }
        
        function stampaContenutiCategoria() {
            while($articolo = $this->risultatiRicerca->fetch_assoc()) {
                $numeroCommenti = $this->db->contaRigheTabella("geecB_commenti",array("idContenuto",$articolo["id"]));
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);
                
                $arrayCategorie = array();
                if($articolo["categoria"]!=0) {
                    $categoriaPrincipale = $this->db->leggiSingolaRiga("geec_categorie",$articolo["categoria"]);
                    $arrayCategorie[$categoriaPrincipale["nome"]] = GeneratoreUrl::creaUrlCategoria($categoriaPrincipale, $this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);
                }
                $queryArticoli="SELECT c.* FROM geec_associazioneCategorieContenuti AS ac JOIN geec_categorie AS c "
                                . "ON c.id=ac.idCategoria "
                                . "WHERE ac.idContenuto = {$articolo["id"]}";
                $risCategorie = $this->db->eseguiQueryLettura($queryArticoli);
                while($categoria = $risCategorie->fetch_assoc()) {
                    $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $this->impostazioniAspetto["ottimizzazioneUrl"],$this->impostazioniAspetto["urlSito"]);
                }
                
                $dataPubblicazione = date("d/m/Y",strtotime($articolo["dataPubblicazione"]));
                $testoAnteprima = explode("<!-- leggi tutto -->", strip_tags($articolo["testo"]))[0];
                if($this->chiaveRicerca["tipoVisualizzazione"]=="classico") {
                    StampaContenuti::visualizzazioneClassica($this->gestoreTraduzioni,$articolo, $this->datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo, $testoAnteprima, $dataPubblicazione, $arrayCategorie, $numeroCommenti);
                }
                else if($this->chiaveRicerca["tipoVisualizzazione"]=="compatto") {
                    StampaContenuti::visualizzazioneCompatta($this->gestoreTraduzioni,$articolo, $this->datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo, $testoAnteprima, $dataPubblicazione, $arrayCategorie, $numeroCommenti);
                }
                else { // visualizzazione solo titolo
                    StampaContenuti::visualizzazioneSoloTitolo($linkArticolo, $articolo["titolo"]);
                }
            }
        }
        
        function stampaPaginazione($parametriAggiuntivi="") {
            
            if($this->tipo=="categoria") {
                $stringaParametriAggiuntivi = "&tipoRicerca=categoria&chiaveRicerca={$this->chiaveRicerca["alias"]}".$parametriAggiuntivi;
            }
            else {
                $stringaParametriAggiuntivi = "&chiaveRicerca={$_GET["chiaveRicerca"]}&tipoRicerca=$this->tipo".$parametriAggiuntivi;
            }
                        
            if($this->numeroRisultatiRicerca > $this->elementiPerPagina) {
                echo"<nav aria-label=\"Paginazione\" class=\"my-2\">
                        <ul class=\"pagination justify-content-center\">";
                        // due frecce, per andare alla prima pagina. Se si trova alla prima pagina non viene mostrate
                        if($this->pagina==1) {

                        }
                        else {
                            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"cerca.php?pag=1$stringaParametriAggiuntivi\"><i class=\"fas fa-angle-double-left fa-xs\"></i></a></li>";
                        }

                        // una freccia, per andare alla pagina precedente. Se si trova alla prima pagina non viene mostrate
                        if($this->pagina==1) {

                        }
                        else {
                            $prec = $this->pagina-1;
                            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"cerca.php?pag=$prec$stringaParametriAggiuntivi\"><i class=\"fas fa-angle-left fa-xs\"></i></a></li>";
                        }

                        $numeroPagine = ceil($this->numeroRisultatiRicerca/$this->elementiPerPagina);
                        if($numeroPagine > 5) {
                            $limiteInferiore = $this->pagina - 2;
                            if($limiteInferiore < 1) {
                                $limiteInferiore = 1;
                            }
                            if($this->pagina == 1) {
                                $limiteSuperiore=5;
                            }
                            else {
                                $limiteSuperiore = $this->pagina + 2;
                            }
                            if($limiteSuperiore > $numeroPagine) {
                                $limiteSuperiore = $numeroPagine;
                            }
                            if($limiteInferiore > 1) {
                                echo"<li class=\"page-item\"><a class=\"page-link\" >...</a></li>";
                            }
                            for($i=$limiteInferiore;$i<$limiteSuperiore+1;$i++) {
                                if($i==$this->pagina) {
                                    echo"<li class=\"page-item active\"><a class=\"page-link\" href=\"\">$i</a></li>";				
                                }
                                else {
                                    echo"<li class=\"page-item\"><a class=\"page-link\" href=\"cerca.php?pag=$i$stringaParametriAggiuntivi\">$i</a></li>";
                                }
                            }
                            if($limiteSuperiore < $numeroPagine) {
                                echo"<li class=\"page-item\"><a class=\"page-link\" >...</a></li>";
                            }
                        }
                        else {	
                            for($i=1;$i<$numeroPagine+1;$i++) {
                                if($i==$this->pagina) {
                                    echo"<li class=\"page-item active\"><a class=\"page-link\" href=\"\">$i</a></li>";				
                                }
                                else {
                                    echo"<li class=\"page-item\"> <a class=\"page-link\" href=\"cerca.php?pag=$i$stringaParametriAggiuntivi\">$i</a></li>";
                                }
                            }
                        }

                        // una freccia, serve per andare alla pagina successiva. Se è già all'ultima pagina non viene mostrata
                        if($this->pagina==$numeroPagine) {

                        }
                        else {
                            $succ = $this->pagina+1;
                            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"cerca.php?pag=$succ$stringaParametriAggiuntivi\"><i class=\"fas fa-angle-right fa-xs\"></i></a></li>";
                        }

                        // due freccie, servono per andare alla pagina successiva. Se è già all'ultima pagina non viene mostrata
                        if($this->pagina==$numeroPagine) {

                        }
                        else {
                            echo"<li class=\"page-item\"><a class=\"page-link\" href=\"cerca.php?pag=$numeroPagine$stringaParametriAggiuntivi\"><i class=\"fas fa-angle-double-right fa-xs\"></i></a></li>";
                        }
                echo"</ul>
                </nav>";
            }
        }
        
        function creaStringaQuery($parametri,$chiave,$operatore="OR") {
            $stringa = "";
            $i = 0;
            
            foreach($parametri as $parametro) {
                if($i==0) {
                    $stringa .= "$parametro LIKE '%$chiave%'";
                }
                else {
                    $stringa .= "$operatore $parametro LIKE '%$chiave%'";
                }
                $i++;
            }
            return $stringa;
        }
        
        function salvaRicercaNelDatabase() {
            $chiaveRicercaEscape = filter_var($this->chiaveRicerca,FILTER_SANITIZE_ADD_SLASHES);
            $query = "SELECT * FROM geecB_ricercheEffettuate WHERE parolaChiave LIKE '$chiaveRicercaEscape'";
            $risultatoRicerca = $this->db->eseguiQueryLettura($query);
            
            $dataOggi  = date("Y-m-d");
            if($risultatoRicerca->num_rows>0) {
                $ricercaEffettuata = $risultatoRicerca->fetch_assoc();
                $queryInserimentoRicerca = "UPDATE `geecB_ricercheEffettuate` SET numeroRicerche = numeroRicerche+1, ultimaRicerca='$dataOggi' WHERE id={$ricercaEffettuata["id"]}";                
            }
            else {                
                $queryInserimentoRicerca = "INSERT INTO `geecB_ricercheEffettuate` (`id`, `tipo`, `parolaChiave`, `numeroRicerche`, `primaRicerca`, `ultimaRicerca`) VALUES (NULL, '$this->tipo', '$this->chiaveRicerca', '1', '$dataOggi', '$dataOggi');";
            }
            $this->db->eseguiQueryLettura($queryInserimentoRicerca);
        }
        
        // Getter e setter
        function getTitoloPagina() {
            if($this->tipo=="autore") {
                return "<p class=\"text-muted\">$this->numeroRisultatiRicerca articoli dell'autore <strong>$this->chiaveRicerca</strong></p>";
            }
            else if($this->tipo=="categoria") {
                return "<p class=\"text-muted\">$this->numeroRisultatiRicerca articoli nella categoria  <strong>{$this->chiaveRicerca["nome"]}</strong></p>";
            }
            else {
                return "<p class=\"text-muted\">$this->numeroRisultatiRicerca risultati per <strong>$this->chiaveRicerca</strong></p>";
            }
        }
        
        function getDb() {
            return $this->db;
        }

        function getTipo() {
            return $this->tipo;
        }

        function getImpostazioni() {
            return $this->impostazioni;
        }
        
        function getChiaveRicerca() {
            return $this->chiaveRicerca;
        }

        function getRisultatiRicerca() {
            return $this->risultatiRicerca;
        }
        
        function getNumeroRisultatiRicerca() {
            return $this->numeroRisultatiRicerca;
        }
        
        function getPagina() {
            return $this->pagina;
        }
        
        function getContenutoSopraTitoloPagina() {
            return $this->contenutoSopraTitoloPagina;
        }
        
        public function getElementiPerPagina() {
            return $this->elementiPerPagina;
        }
        
        function getImpostazioniAspetto() {
            return $this->impostazioniAspetto;
        }
                
        function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }
        
        function setPagina($pagina) {
            $this->pagina = $pagina;
        }

        function setQueryConteggio($queryConteggio) {
            $this->queryConteggio = $queryConteggio;
        }
        
        function setQueryRicerca($queryRicerca) {
            $this->queryRicerca = $queryRicerca;
        }

        function setTipo($tipo): void {
            $this->tipo = $tipo;
        }
        
        public function setImpostazioni($impostazioni): void {
            $this->impostazioni = $impostazioni;
        }

        function setChiaveRicerca($chiaveRicerca): void {
            $this->chiaveRicerca = $chiaveRicerca;
        }

        function setContenutoSopraTitoloPagina($contenutoSopraTitoloPagina): void {
            $this->contenutoSopraTitoloPagina = $contenutoSopraTitoloPagina;
        }

        public function setElementiPerPagina($elementiPerPagina): void {
            $this->elementiPerPagina = $elementiPerPagina;
        }

        function setImpostazioniAspetto($impostazioniAspetto): void {
            $this->impostazioniAspetto = $impostazioniAspetto;
        }
        
        function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }
    }
